﻿namespace Microsoft.Samples.PlanMyNight.AddIns.Share.Tests.Controllers
{
    using System;
    using System.Web.Mvc;
    using Microsoft.Samples.PlanMyNight.AddIns.Share.Controllers;
    using Microsoft.Samples.PlanMyNight.AddIns.Share.Models;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;
    using MvcContrib.TestHelper;
    using Rhino.Mocks;

    [TestClass]
    public class SharingControllerFixture
    {
        [TestMethod]
        public void ShortUrlForAjaxReturnsJsonResult()
        {
            var urlService = new Mock<IShortenUrlService>();
            urlService.Setup(o => o.GeneratedShortUrl("http://www.planmynight.net/Itineraries/123"))
                      .Returns(new Uri("http://tiny.com/123", UriKind.Absolute));

            var controller = new SharingController(urlService.Object);
            var builder = new TestControllerBuilder();
            builder.HttpContext.Request.Stub(a => a.ContentType).Return("application/json");
            builder.InitializeController(controller);

            var result = controller.ShortUrl("http://www.planmynight.net/Itineraries/123").AssertResultIs<JsonResult>();
            Assert.AreEqual(new Uri("http://tiny.com/123", UriKind.Absolute), result.Data as Uri);
        }

        [TestMethod]
        public void ShortUrlForNonAjaxReturnsViewResult()
        {
            var urlService = new Mock<IShortenUrlService>();
            urlService.Setup(o => o.GeneratedShortUrl("http://www.planmynight.net/Itineraries/123"))
                      .Returns(new Uri("http://tiny.com/123", UriKind.Absolute));

            var controller = new SharingController(urlService.Object);
            var builder = new TestControllerBuilder();
            builder.HttpContext.Request.Stub(a => a.ContentType).Return("text/html");
            builder.InitializeController(controller);

            var result = controller.ShortUrl("http://www.planmynight.net/Itineraries/123")
                                   .AssertViewRendered();
            Assert.IsTrue(result.ViewName.Contains("ShortUrl"));
        }

        [TestMethod]
        public void ShortUrlToolbox()
        {
            var controller = new SharingController(new Mock<IShortenUrlService>().Object);
            var builder = new TestControllerBuilder();
            builder.InitializeController(controller);

            var viewName = controller.ShortUrlToolbox().AssertResultIs<PartialViewResult>().ViewName;
            Assert.IsTrue(viewName.Contains("ShortUrlToolbox"));
        }

        [TestMethod]
        public void ShareToolboxReturnsPartialView()
        {
            var controller = new SharingController(new Mock<IShortenUrlService>().Object);
            var builder = new TestControllerBuilder();
            builder.InitializeController(controller);

            var view = controller.ShareToolbox("http://tempuri.org/", "Test").AssertResultIs<PartialViewResult>();

            Assert.AreEqual("http://tempuri.org/", view.ViewData["url"]);
            Assert.AreEqual("Test", view.ViewData["title"]);
        }
    }
}
